/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.controller;

import java.util.Collection;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import pt.caf_pbs.schooldiskapi.dao.FilesOperation;
import pt.caf_pbs.schooldiskapi.dto.SubjectDTO;
import pt.caf_pbs.schooldiskapi.dto.SubjectUpdateDTO;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;
import pt.caf_pbs.schooldiskapi.model.School;
import pt.caf_pbs.schooldiskapi.model.Subject;

@RestController
@RequestMapping(value={"/v1/subject"})
public class SubjectsController {
    @PutMapping(value={"{initials}"})
    public Subject updateSubject(@PathVariable String initials, @RequestBody SubjectUpdateDTO subjectDTO) {
        try {
            School school = FilesOperation.loadSchool();
            school.getSubjectContainer().update(initials, subjectDTO.getDesignation());
            FilesOperation.storeSchool((School)school);
            return school.getSubjectContainer().get(initials);
        }
        catch (InvalidDataException e) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with " + e.getMessage(), (Throwable)e);
        }
    }

    @PostMapping
    public Subject createSubject(@RequestBody SubjectDTO subjectDTO) {
        try {
            School school = FilesOperation.loadSchool();
            Subject newSubject = new Subject(subjectDTO);
            school.getSubjectContainer().add(newSubject);
            FilesOperation.storeSchool((School)school);
            return newSubject;
        }
        catch (DuplicatedDataException | InvalidDataException e) {
            throw new ResponseStatusException(HttpStatus.CONFLICT, "Problems with " + e.getMessage(), e);
        }
    }

    @GetMapping(value={"{initials}"})
    public Subject getSubject(@PathVariable String initials) {
        School school = FilesOperation.loadSchool();
        Subject subject = school.getSubjectContainer().get(initials);
        if (subject != null) {
            return subject;
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Subject with id " + initials + " found");
    }

    @GetMapping(value={"all"})
    public List<Subject> getAllSubject() {
        School school = FilesOperation.loadSchool();
        List subject = school.getSubjectContainer().getSubjects();
        if (CollectionUtils.isEmpty((Collection)subject)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Subjects found");
        }
        return subject;
    }

    @DeleteMapping(value={"{initials}"})
    public Subject deleteSubject(@PathVariable String initials) {
        School school = FilesOperation.loadSchool();
        Subject student = school.getSubjectContainer().get(initials);
        if (student != null) {
            school.getSubjectContainer().remove(initials);
            FilesOperation.storeSchool((School)school);
            return student;
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No Subject with initials " + initials + " found");
    }
}

